<?php
/* --------------------------------------------------------------
   Permission.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Permission\Model;

use Gambio\Core\Permission\PermissionDefinition;
use Gambio\Core\Permission\UserId;

/**
 * Class Permission
 *
 * @package Gambio\Core\Auth\Model
 */
class Permission implements \Gambio\Core\Permission\Permission
{
    /**
     * @var UserId
     */
    private $userId;
    
    /**
     * @var PermissionDefinition
     */
    private $definition;
    
    /**
     * @var bool
     */
    private $isGranted;
    
    
    /**
     * Permission constructor.
     *
     * @param UserId               $userId
     * @param PermissionDefinition $definition
     * @param bool                 $isGranted
     */
    private function __construct(UserId $userId, PermissionDefinition $definition, bool $isGranted)
    {
        $this->userId     = $userId;
        $this->definition = $definition;
        $this->isGranted  = $isGranted;
    }
    
    
    /**
     * @param UserId               $userId
     * @param PermissionDefinition $definition
     * @param bool                 $isGranted
     *
     * @return Permission
     */
    public static function create(
        UserId $userId,
        PermissionDefinition $definition,
        bool $isGranted
    ): Permission {
        return new self($userId, $definition, $isGranted);
    }
    
    
    /**
     * @inheritDoc
     */
    public function userId(): int
    {
        return $this->userId->userId();
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->definition->type();
    }
    
    
    /**
     * @inheritDoc
     */
    public function identifier(): string
    {
        return $this->definition->identifier();
    }
    
    
    /**
     * @inheritDoc
     */
    public function action(): string
    {
        return $this->definition->action();
    }
    
    
    /**
     * @inheritDoc
     */
    public function isGranted(): bool
    {
        return $this->isGranted;
    }
}